;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_3.inc
;;   Version: 2.3, Updated on 2004/07/19 at 16:37:39
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_3 API's.
;--------------------------------------------------

PWM8_3_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_3_INT_REG:                            equ 0x0df
PWM8_3_INT_MASK:                           equ 0x01


;--------------------------------------------------
; Constants for PWM8_3 user defined values
;--------------------------------------------------

PWM8_3_PERIOD:                             equ 0xfe
PWM8_3_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_3
;--------------------------------------------------

PWM8_3_COUNTER_REG:                    equ 0x40   ; DR0 Count register
PWM8_3_PERIOD_REG:                     equ 0x41   ; DR1 Period register
PWM8_3_COMPARE_REG:                    equ 0x42   ; DR2 Compare register
PWM8_3_CONTROL_REG:                    equ 0x43   ; Control register
PWM8_3_FUNC_REG:                       equ 0x40   ; Function register
PWM8_3_INPUT_REG:                      equ 0x41   ; Input register
PWM8_3_OUTPUT_REG:                     equ 0x42   ; Output register


;--------------------------------------------------
; PWM8_3 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_3_Start_M
   or    reg[PWM8_3_CONTROL_REG],  PWM8_3_CONTROL_REG_START_BIT
   endm

   macro PWM8_3_Stop_M
   and   reg[PWM8_3_CONTROL_REG], ~PWM8_3_CONTROL_REG_START_BIT
   endm

   macro PWM8_3_EnableInt_M
   M8C_EnableIntMask PWM8_3_INT_REG, PWM8_3_INT_MASK
   endm

   macro PWM8_3_DisableInt_M
   M8C_DisableIntMask PWM8_3_INT_REG, PWM8_3_INT_MASK
   endm


; end of file PWM8_3.inc
